<?php

$cs = Yii::app()->clientScript;
$cs->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.js');
$cs->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.categories.js');
$cs->registerScriptFile(Yii::app()->baseUrl. '/js/admin/main.js');
$cs->registerCssFile(Yii::app()->baseUrl.'/css/ui/themes/smoothness/jquery-ui.min.css');
$cs->registerCoreScript('jquery.ui');

$this->breadcrumbs = array(
	'Klasy'=>array('/teacher/main/classes'),
	'Klasa '.$model->klasa->nazwa=>array('/teacher/main/class','id'=>$model->idKlasy),
	'Szczegóły firmy '.$model->nazwa,
);

$punktacja = $model->getStatistics();
?>

<?php if(Yii::app()->user->hasFlash('formStatusChanged')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('formStatusChanged'); ?>
	</div>
<?php endif; ?>

<h1>Szczegóły firmy <?php echo $model->nazwa ?></h1>

<p>
	<b>Firma:</b> <?php echo $model->nazwa ?>
</p>

<p>
	<b>Klasa:</b> <?php echo $model->klasa->nazwa ?>
</p>

<p>
	<b>Członkowie:</b>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'firma-booknotes-lista',
	'dataProvider'=>new CArrayDataProvider($model->uzytkownicy),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Imię i nazwisko',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/teacher/main/student",
				array("id"=>$data->id)) . "\">" . $data->imie . \' \' . $data->nazwisko . "</a>"',
			'type'=>'raw'
		),
	),
));
?>
</p>

<p>
	<b>Punkty wg. dziedziny:</b>

	<div>
		<div style="display:inline-block;width:720px">
			<div class="bars" id="placeholder1"></div>
		</div>
		<div style="display:inline-block;width:100px;float:right">
			<div class="bars" id="graphStanKonta"></div>
		</div>
	</div>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'dataProvider' => $punktacja,
	'htmlOptions' => array('class' => 'tDefault'),
	'summaryText' => false,
	'columns' => array(
		array(
			'header' => 'Dziedzina',
			'value' => '$data["nazwa"]'
		),
		array(
			'header' => 'Punkty',
			'value' => '$data["nazwa"] == "Stan konta" ? "'.$model["stanKonta"].'" . " PLN" : $data["punkty"]',
		)
	),
));
?>

</p>

<p>
	<b>Biuro:</b>
	<?php if(!empty($model->biura) && !empty($model->biura[0]->budynek))
			echo $model->biura[0]->budynek->nazwa.' '.$model->biura[0]->budynek->adres;
		else
			echo 'brak'; ?>
</p>

<style>
	#tabs a:link {
		font-weight: normal;
		text-decoration: none;
	}
	#tabs a:hover {
		font-weight: normal;
		text-decoration: underline;
	}
</style>

<div id="tabs">
	<ul>
		<li><a href="#tabs-1">Formularze</a></li>
		<li><a href="#tabs-2">Certyfikaty</a></li>
		<li><a href="#tabs-3">Faktury VAT</a></li>
		<li><a href="#tabs-4">Faktury kosztowe</a></li>
		<li><a href="#tabs-5">Noty księgowe</a></li>
		<li><a href="#tabs-6">Zlecenia</a></li>
	</ul>
	<div id="tabs-1">
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'parametry-gry-grid',
	'dataProvider'=>$forms,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'name'=>'nazwa',
			'header'=>'Nazwa formularza',
			'value'=>'\'<a href="\'.Yii::app()->createUrl("/teacher/main/form",array("userFormId"=>$data["id"])).\'">\'.$data["nazwa"].\'</a>\'',
			'type'=>'raw'
		),
		array(
			'header'=>'Status',
			'value'=>'FormularzUzytkownika::$statusName[$data["status"]]'
		),
		array(
			'header'=>'Akcje',
			'value'=>'($data["status"]==FormularzUzytkownika::STATUS_FILLED || $data["status"]==FormularzUzytkownika::STATUS_REFUSED ?\'<a class="buttonS bGreen" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_ACCEPTED)).\'">Zaakceptuj</a>\':""). ($data["status"]==FormularzUzytkownika::STATUS_FILLED ?\' | \':""). ($data["status"]==FormularzUzytkownika::STATUS_FILLED?\'<a class="buttonS bRed" href="\'.Yii::app()->createUrl("teacher/main/formStatusChange",array("userFormId"=>$data["id"],"status"=>FormularzUzytkownika::STATUS_REFUSED)).\'">Odrzuć</a>\':"")',
			'type'=>'raw'
		)
	),
));
?>
	</div>
	<div id="tabs-2">
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'firma-certyfikaty-lista',
	'dataProvider'=>new CArrayDataProvider($model->certyfikaty),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Nazwa',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/certificate",
				array("id"=>$data->id)) . "\">" . $data->idSzkolenia0->nazwa . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Dziedzina',
			'name'=>'idSzkolenia0.dziedzina.nazwa'
		),
		array(
			'header'=>'Poziom',
			'name'=>'idSzkolenia0.poziomStr'
		),
		array(
			'header'=>'Otrzymano',
			'name'=>'dataZakonczeniaYmd'
		),
	),
));
?>
	</div>
	<div id="tabs-3">
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'firma-faktury-vat-lista',
	'dataProvider'=>new CArrayDataProvider($model->fakturyVat),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Nr',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/invoice",
				array("id"=>$data->id)) . "\">" . $data->nrFaktury . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Opis',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/invoice",
				array("id"=>$data->id)) . "\">" . $data->opis . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Netto [zł]',
			'value'=>'number_format($data->cenaNetto, 2, ",", " ")'
		),
		array(
			'header'=>'Brutto [zł]',
			'value'=>'number_format($data->cenaBrutto, 2, ",", " ")'
		),
		array(
			'header'=>'Wystawiona',
			'name'=>'dataWystawieniaYmd'
		),
	),
));
?>
	</div>
	<div id="tabs-4">
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'firma-faktury-vat-lista',
	'dataProvider'=>new CArrayDataProvider($model->fakturyKosztowe),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Nr',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/invoice",
				array("id"=>$data->id)) . "\">" . $data->nrFaktury . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Opis',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/invoice",
				array("id"=>$data->id)) . "\">" . $data->opis . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Netto [zł]',
			'value'=>'number_format($data->cenaNetto, 2, ",", " ")'
		),
		array(
			'header'=>'Brutto [zł]',
			'value'=>'number_format($data->cenaBrutto, 2, ",", " ")'
		),
		array(
			'header'=>'Wystawiona',
			'name'=>'dataWystawieniaYmd'
		),
	),
));
?>
	</div>
	<div id="tabs-5">
<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'firma-booknotes-lista',
	'dataProvider'=>new CArrayDataProvider($model->notyKsiegowe),
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Nr umowy',
			'value'=>'"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/student/main/bookNote",
				array("id"=>$data->id)) . "\">" . $data->nrUmowy . "</a>"',
			'type'=>'raw'
		),
		array(
			'header'=>'Dziedzina',
			'name'=>'idZlecenia0.dziedzina.nazwa'
		),
		array(
			'header'=>'Kategoria',
			'name'=>'idZlecenia0.kategoria'
		),
		array(
			'header'=>'Poziom',
			'name'=>'idZlecenia0.poziomStr'
		),
		array(
			'header'=>'Kontrahent',
			'name'=>'kontrahent.nazwa'
		),
		array(
			'header'=>'Kara [zł]',
			'value'=>'number_format($data->idZlecenia0->kwotaKary, 2, ",", " ")'
		),
	),
));
?>
	</div>
	<div id="tabs-6">
	<?php
		$this->widget('application.modules.teacher.widgets.OrdersList', array(
			'companyId' => $model->id
		));
	?>
	</div>
</div>

<script type="text/javascript">
	$(function() {

		$('#tabs').tabs();

		var data = new Array();
		var dataObject = <?php echo json_encode($punktacja->data) ?>;
		var dataStanKonta = [];

		var statGraphData = colourBars(dataObject, data, function(prop, val) {
			if (val.nazwa != 'Stan konta')
				return [val.nazwa, parseFloat(val.punkty)];
			else
				dataStanKonta.push([val.nazwa, parseFloat(val.punkty)]);
		});

		//Display graph
		$.plot($("#placeholder1"), statGraphData, {
			grid: {
				hoverable: true
			},
			xaxis: {
				mode: "categories",
				tickLength: 0
			},
			bars: {
				show: true,
				barWidth: 0.2,
				order: 1,
			},
			legend: true,
		});

		//Display graph (Stan konta)
		$.plot($("#graphStanKonta"), [dataStanKonta], {
			grid: {
				hoverable: true
			},
			yaxis: {
				position: 'right',
				max: parseFloat(<?php echo $model->maximumStanKonta * 1.1; ?>)
			},
			xaxis: {
				mode: "categories",
				tickLength: 0
			},
			bars: {
				show: true,
				barWidth: 0.2,
				order: 1,
			},
			legend: true,
		});

		//tooltip function
		function showTooltip(x, y, contents, areAbsoluteXY) {
			var rootElt = 'body';

			$('<div id="tooltip2" class="tooltip">' + contents + '</div>').css({
				position: 'fixed',
				display: 'none',
				top: y - 35,
				left: x - 5,
				'z-index': '9999',
				'color': '#fff',
				'font-size': '11px',
				opacity: 0.8
			}).prependTo(rootElt).show();
		}

		//add tooltip event
		$("#placeholder1, #graphStanKonta").bind("plothover", function(event, pos, item) {
			if (item) {
				if (previousPoint != item.datapoint) {
					previousPoint = item.datapoint;

					//delete de prГ©cГ©dente tooltip
					$('.tooltip').remove();

					var x = item.datapoint[0];

					//All the bars concerning a same x value must display a tooltip with this value and not the shifted value
					if (item.series.bars.order) {
						for (var i = 0; i < item.series.data.length; i++) {
							if (item.series.data[i][3] == item.datapoint[0])
								x = item.series.data[i][0];
						}
					}

					var y = item.datapoint[1];

					showTooltip(item.pageX + 5, item.pageY + 5, $(this)[0] == $('#graphStanKonta')[0] ? 'Stan konta: ' + y + ' PLN' : 'Punkty: ' + y);

				}
			}
			else {
				$('.tooltip').remove();
				previousPoint = null;
			}

		});

	});
</script>

